<div class="form-box" id="login-box">
    <div class="header">Forget Password?</div>
    <?php echo $this->Form->create('User'); ?>
    <div class="body bg-gray">

        <?php echo $this->Flash->render(); ?>
        <p>
            Enter your e-mail address below to reset your password.
        </p>

        <div class="form-group">
            <?php
            echo $this->Form->input('email', array(
                'label'        => false,
                'div'          => false,
                'class'        => 'form-control ',
                'placeholder'  => 'Email',
                'autocomplete' => 'off'
            ));
            ?>
        </div>

        <?php if (isset_recaptcha()) {
    ?>
            <p>Prove you’re not a robot</p>

            <div class="form-group">
                <script src='https://www.google.com/recaptcha/api.js' async defer></script>
                <div class="g-recaptcha" data-sitekey="<?php echo Configure::read('Option.recaptcha_siteKey');
    ?>"></div>
                <?php $this->Form->unlockField('g-recaptcha-response');
    ?>
            </div>
        <?php 
} ?>

    </div>
    <div class="footer">
        <?php
        echo $this->Form->end(array(
            'label' => 'Submit',
            'class' => 'btn bg-olive btn-block'
        ));
        ?>

        <div class="create-account">
            <h4>Don't have an account yet?</h4>
            <p><a href="<?php echo $this->Html->url(array( 'controller' => 'users', 'action' => 'register', 'prefix' => 'members', 'members' => true )); ?>">
                    Create an account
                </a>
            </p>
        </div>
    </div>
</form>
</div>
